class Table {
    constructor(container, types, columns, data = []) {
        this.container = document.querySelector(container);
        this.types = types;
        this.columns = columns.map(col => Object.values(col)[0]);
        this.keys = columns.map(col => Object.keys(col)[0]);
        this.data = data;
        this.render();
    }

    render() {
       this.container.innerHTML = '';

        const tableWrapper = document.createElement('div');
        tableWrapper.classList.add('table-wrapper');

        const table = document.createElement('table');
        table.classList.add('tableStyle');

        const thead = document.createElement('thead');
        const headerRow = document.createElement('tr');

        const thNN = document.createElement('th');
        thNN.textContent = "NN";
        thNN.className = "nn";
        headerRow.appendChild(thNN);

        this.columns.forEach(col => {
            const th = document.createElement('th');
            th.textContent = col;
            headerRow.appendChild(th);
        });

        thead.appendChild(headerRow);
        table.appendChild(thead);

        const tbody = document.createElement('tbody');
        this.data.forEach((row, index) => {
            const tr = document.createElement('tr');

            /*   const tdIndex = document.createElement('td');
               tdIndex.textContent = index + 1;
               tr.appendChild(tdIndex);
           */
            const td = document.createElement('td');
            const bt = document.createElement('input');
            bt.type = "button";
            td.className = "nn";
            bt.value = index + 1;
            bt.addEventListener('click', (event) => this.checkRow(event));
            td.appendChild(bt);
            tr.appendChild(td);

            this.keys.forEach((key, i) => {
                const td = document.createElement('td');
                const type = this.types[i];

                if (type === 'checkbox') {
                    const input = document.createElement('input');
                    input.type = 'checkbox';
                    input.checked = row[key] === true || row[key] === "true";
                    td.appendChild(input);
                } else {
                    td.contentEditable = true;
                    td.textContent = row[key] || '';
                    td.classList.add('editable');
                }
                td.tabIndex = 0;

                tr.appendChild(td);
            });

            tbody.appendChild(tr);
        });

        table.appendChild(tbody);
        tableWrapper.appendChild(table);

        const navigator = this.createRecordNavigator();
        tableWrapper.appendChild(navigator);



        const saveBtn = document.createElement('button');
        saveBtn.textContent = "Պահպանել տվյալները";
        saveBtn.className = "save-button";
        saveBtn.addEventListener('click', () => {
            const data = this.getData();
            console.log("📥 Պահպանված տվյալներ:", data);
            alert("Տվյալները պահվեցին։ Ստուգիր console.log()");
        });

        tableWrapper.appendChild(saveBtn);
        this.container.appendChild(tableWrapper);

        this.addKeyboardNavigation();

    }

    getData() {
        const result = [];
        const rows = this.container.querySelectorAll('tbody tr');

        rows.forEach(row => {
            const cells = row.querySelectorAll('td');
            const rowData = {};

            for (let i = 1; i <= this.keys.length; i++) {
                const key = this.keys[i - 1];
                const type = this.types[i - 1];
                const cell = cells[i];

                if (type === 'checkbox') {
                    const input = cell.querySelector('input');
                    rowData[key] = input?.checked || false;
                } else {
                    rowData[key] = cell.textContent.trim();
                }
            }

            result.push(rowData);
        });

        return result;
    }

    addKeyboardNavigation() {
        const rows = this.container.querySelectorAll("tbody tr");

        rows.forEach((tr, rowIndex) => {
            const cells = tr.querySelectorAll("td");

            cells.forEach((td, colIndex) => {
                // Пропускаем NN колонку (index 0)
                if (colIndex === 0) return;

                // Делаем td focusable
                td.tabIndex = 0;

                td.addEventListener("keydown", (e) => {
                    let targetRow = rowIndex;
                    let targetCol = colIndex;

                    switch (e.key) {
                        case "ArrowDown":
                            e.preventDefault();
                            targetRow = rowIndex + 1;
                            break;
                        case "ArrowUp":
                            e.preventDefault();
                            targetRow = rowIndex - 1;
                            break;
                        case "Enter":
                        case "ArrowRight":
                            e.preventDefault();
                            targetCol = colIndex + 1;
                            break;
                        case "ArrowLeft":
                            e.preventDefault();
                            targetCol = colIndex - 1;
                            break;
                        default:
                            return;
                    }

                    const targetRowEl = rows[targetRow];
                    if (targetRowEl) {
                        const targetCell = targetRowEl.querySelectorAll("td")[targetCol];
                        if (targetCell) {
                            targetCell.focus();
                        }
                    }
                });
            });
        });
    }

    createRecordNavigator() {
        const nav = document.createElement('div');
        nav.className = 'record-navigator';

        const label = document.createElement('span');
        label.textContent = 'Տողը:';
        nav.appendChild(label);

        const firstBtn = this.createNavButton('⏮', () => this.focusRow(0));
        const prevBtn = this.createNavButton('◀', () => this.focusRow(this.currentRow - 1));
        const nextBtn = this.createNavButton('▶', () => this.focusRow(this.currentRow + 1));
        const lastBtn = this.createNavButton('⏭', () => this.focusRow(this.data.length - 1));
        //const addBtn = this.createNavButton('✳', () => this.addRow({}));
        const addBtn = this.createNavButton('✳', () => this.addRow());

        this.recordInput = document.createElement('input');
        this.recordInput.type = 'number';
        this.recordInput.min = 1;
        this.recordInput.value = 1;
        this.recordInput.style.width = '50px';

        this.recordInput.addEventListener('change', () => {
            const index = parseInt(this.recordInput.value, 10) - 1;
            this.focusRow(index);
        });

        const of = document.createElement('span');
        of.textContent = ` / ${this.data.length}`;

        nav.appendChild(firstBtn);
        nav.appendChild(prevBtn);
        nav.appendChild(this.recordInput);
        nav.appendChild(nextBtn);
        nav.appendChild(lastBtn);
        nav.appendChild(addBtn);
        nav.appendChild(of);

        this.currentRow = 0;

        return nav;
    }
    createNavButton(label, onClick) {
        const btn = document.createElement('button');
        btn.textContent = label;
        btn.className = 'nav-btn';
        btn.addEventListener('click', onClick);
        return btn;
    }
    focusRow(index) {
        const rows = this.container.querySelectorAll('tbody tr');
        if (index < 0 || index >= rows.length) return;

        // Убрать выделение со всех
        rows.forEach(row => row.classList.remove('active-row'));

        const row = rows[index];
        if (row) {
            row.classList.add('active-row');
            row.scrollIntoView({ behavior: "smooth", block: "center" });

            const editable = row.querySelector('td[contenteditable], td input[type="checkbox"]');
            if (editable) editable.focus();

            this.currentRow = index;
            this.recordInput.value = index + 1;
        }
    }
    /*  checkRow(event) {
          const button = event.currentTarget;
          const rowElement = button.closest('tr');
  
          const rows = this.container.querySelectorAll('tbody tr');
          rows.forEach(r => r.classList.remove('active-row'));
  
          if (rowElement) {
              rowElement.classList.add('active-row');
              console.log("Clicked row:", rowElement);
          }
      }
      */
    checkRow(event) {
        const button = event.currentTarget;
        const rowElement = button.closest('tr');

        //նշել ընթացիկ տողը
        if (rowElement) {
            if (rowElement.classList.contains('active-row')) {
                rowElement.classList.remove('active-row');
            } else {
                rowElement.classList.add('active-row');
            }
            console.log("Clicked row:", rowElement);
        }
    }

    addRow() {
        const emptyRow = {};
        this.keys.forEach((key, i) => {
            const type = this.types[i];
            if (type === 'checkbox') {
                emptyRow[key] = false;
            } else {
                emptyRow[key] = '';
            }
        });

        this.data.push(emptyRow);
        this.render();

        // Перейти на новую строку
        this.focusRow(this.data.length - 1);
    }


}
